<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../utils/helpers.php';

function getBigCommerceOrder($orderId) {
  $url = BC_API_URL . "orders/$orderId";
  $response = http_get($url, [
    "X-Auth-Token: " . BC_ACCESS_TOKEN,
    "Accept: application/json"
  ]);
  file_put_contents(__DIR__.'/orders1.json',json_encode($response,JSON_PRETTY_PRINT));
  if (!$response['success']) {
    error_log("BC API Error: " . json_encode($response));
    return null;
  }

  return $response['data'];
}

function markOrderAsPaid($orderId, $paymentMethod = 'Pesapal', $amount = null, $transactionId = null) {
    if (!$orderId) return false;
     
    $order = getBigCommerceOrder($orderId);
  
    if (!$order) {
        error_log("BC Order not found: $orderId");
        return false;
    }
 
    if ((int)$order['status_id'] !== 7) {
            
        error_log("BC Order $orderId not in Awaiting Payment. Current status: " . $order['status_id']);
        return false; // or return true if you just want to skip
    }
    
    $statusData = [
        'status_id' => 11  // Awaiting fulfillment
    ];
     
    $url = BC_API_URL . "orders/$orderId";
      $updateResponse = http_put_curl($url, $statusData, [
            "X-Auth-Token: " . BC_ACCESS_TOKEN,
            "Accept: application/json",
            "Content-Type: application/json"
        ]);
 
    
    file_put_contents(__DIR__.'/orderupdate.json',json_encode($updateResponse,JSON_PRETTY_PRINT));

    if (!$updateResponse['success']) {
        error_log("BC Order Update Failed: " . json_encode($updateResponse));
        return false;
    }

    // 2️⃣ Optionally, create a transaction for the order
    if ($amount !== null) {
        $transactionData = [
            'order_id' => $orderId,
            'transaction_type' => 'payment', // payment/refund/authorize etc.
            'payment_method' => $paymentMethod,
            'amount' => floatval($amount),
            'transaction_id' => $transactionId ?? uniqid('pesapal_'),
            'date_created' => date('c')
        ];

        $txnUrl = BC_API_URL . "orders/$orderId/transactions";
        $txnResponse = http_post($txnUrl, $transactionData, [
            "X-Auth-Token: " . BC_ACCESS_TOKEN,
            "Accept: application/json",
            "Content-Type: application/json"
        ]);

        if (!$txnResponse['success']) {
            error_log("BC Transaction Creation Failed: " . json_encode($txnResponse));
            // still consider order paid even if transaction creation fails
        }
    }

    return true;
}



function http_put_curl($url, $data, $headers = []) {
    $ch = curl_init($url);

    $payload = json_encode($data);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        return [
            'success' => false,
            'error' => $error,
            'http_code' => $httpCode,
            'data' => null
        ];
    }

    curl_close($ch);

    $decoded = json_decode($response, true);

    return [
        'success' => $httpCode >= 200 && $httpCode < 300,
        'http_code' => $httpCode,
        'data' => $decoded ?? $response
    ];
}
