<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../utils/helpers.php';

function getPesapalToken() {
    $url = PESAPAL_BASE_URL . 'Auth/RequestToken';
    $payload = [
        'consumer_key' => PESAPAL_CONSUMER_KEY,
        'consumer_secret' => PESAPAL_CONSUMER_SECRET,
    ];
    
 

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Accept: application/json'
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    // Save raw response for debugging
    file_put_contents(__DIR__ . '/pesapaltokenres.json', $response);

    if ($error) {
        return null; // or log the error
    }

    $decoded = json_decode($response, true);

    // Adjust according to Pesapal API’s response structure
    if (isset($decoded['token'])) {
        return $decoded['token'];
    }

    return null;
}


function registerPesapalIPN($orderId) {
    $token = getPesapalToken();
    if (!$token) return null;

    $ipn_url = $_ENV['APP_URL'] . "/public/callback.php?order_id=$orderId";

    $payload = [
        'url' => $ipn_url,
        'ipn_notification_type' => "GET" // or POST if you prefer
    ];

    $response = http_post(PESAPAL_BASE_URL . 'URLSetup/RegisterIPN', $payload, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);

    if (!$response['success']) return null;

    return $response['data']['ipn_id'] ?? null;
}


function createPesapalOrder($orderId, $amount, $email,$curr) {
  $token = getPesapalToken();
    file_put_contents(__DIR__.'/pesapaltoken.json',$token);
  if (!$token) return ['error' => 'Failed to get Pesapal token'];
    
  $notification_id = registerPesapalIPN($orderId);
  if (!$notification_id) return ['error' => 'Failed to register IPN'];
  $amount_formatted = number_format((float)$amount, 2, '.', '');
  
  $payload = [
    "id" => uniqid().'-'. $orderId,
    "currency" => $curr,
    "amount" =>$amount_formatted,
    "description" => "Payment for order #{$orderId}",
    "callback_url" => $_ENV['APP_URL'] . "/public/callback.php?order_id=$orderId",
    "notification_id" => $notification_id,
    "billing_address" => [
      "email_address" => $email
    ]
  ];
 
  $response = http_post(PESAPAL_BASE_URL . 'Transactions/SubmitOrderRequest', $payload, [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json'
  ]);
  
   file_put_contents(__DIR__.'/pesapalres.json',json_encode($response,JSON_PRETTY_PRINT));
  if (!$response['success']) return $response;

  return [
    'success' => true,
    'redirect_url' => $response['data']['redirect_url'] ?? null,
    'tracking_id' => $response['data']['order_tracking_id'] ?? null
  ];
}

function verifyPesapalPayment($trackingId) {
    if (!$trackingId) return null;

    $token = getPesapalToken();
    if (!$token) return null;

    $url = PESAPAL_BASE_URL . "Transactions/GetTransactionStatus?orderTrackingId={$trackingId}";

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    $response = curl_exec($ch); 
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    if ($curl_error) {
        file_put_contents(__DIR__.'/pesapal_verify_error.json', $curl_error);
        return null;
    }

    if ($http_code !== 200) return null;

    $data = json_decode($response, true);

    // Map Pesapal payment_status_description or status_code to a simplified status
    $status_map = [
        0 => 'INVALID',
        1 => 'COMPLETED',
        2 => 'FAILED',
        3 => 'REVERSED'
    ];

    $status_code = $data['payment_status_description'] ?? $data['status_code'] ?? null;
    $status = $status_map[$status_code] ?? $data['payment_status_description'] ?? 'UNKNOWN';

    return [
        'status' => $status,                          // COMPLETED, FAILED, INVALID, REVERSED
        'order_id' => $data['merchant_reference'] ?? null,
        'amount' => $data['amount'] ?? null,
        'currency' => $data['currency'] ?? null,
        'payment_method' => $data['payment_method'] ?? null,
        'confirmation_code' => $data['confirmation_code'] ?? null,
        'description' => $data['description'] ?? null,
        'message' => $data['message'] ?? null,
        'raw' => $data                                 // keep full response for debugging
    ];
}