<?php
require_once __DIR__ . '/../lib/pesapal_client.php';
require_once __DIR__ . '/../lib/bigcommerce_client.php';
 

// Get tracking ID from query (Pesapal redirects with ?OrderTrackingId=...)
$trackingId = $_GET['OrderTrackingId'] ?? null;
 
if (!$trackingId) {
    http_response_code(400);
    echo "Missing tracking ID";
    exit;
}

// Optional: verify payment status with Pesapal
$status = verifyPesapalPayment($trackingId);
 
$merchantRef = $status['order_id'] ?? null;

if (!$merchantRef) {
    error_log("Missing merchant_reference in Pesapal callback");
    echo "Missing merchant_reference in Pesapal callback";
    http_response_code(400);
    exit;
}

// Extract the BigCommerce order ID (last part after '-')
$parts = explode('-', $merchantRef);
$bcOrderId = end($parts);

// Now mark as paid
if ($status['status'] === 'Completed') {
    markOrderAsPaid(
        $bcOrderId,
        'Pesapal',
        $status['amount'],
        $status['confirmation_code']
    );
}

// Redirect user to BigCommerce order confirmation page
$order_id = $bcOrderId ?? null;
 
$redirect_url = $order_id 
    ? "https://www.naheri.com/checkout/order-confirmation/{$order_id}?payment_complete=1" 
    : "https://www.naheri.com/checkout/failed";

header("Location: $redirect_url");
exit;
