<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Access-Control-Allow-Origin: https://www.naheri.com");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
$bcPath = __DIR__ . '/../lib/bigcommerce_client.php';
$pesapalPath = __DIR__ . '/../lib/pesapal_client.php';
 
require_once $bcPath;
require_once $pesapalPath;
 


 
     
header('Content-Type: application/json');

try{

$input = json_decode(file_get_contents('php://input'), true);
 
$orderId = $input['orderId'] ?? null;
    if (!$orderId) {
      echo json_encode(['success' => false, 'error' => 'Missing orderId']);
      exit;
    }
    
    $order = getBigCommerceOrder($orderId);
    if (!$order) {
      echo json_encode(['success' => false, 'error' => 'Order not found']);
      exit;
    }
    file_put_contents(__DIR__.'/orderdetails1.json',json_encode($order,JSON_PRETTY_PRINT));
    $amount = $order['total_inc_tax'];
    $email = $order['billing_address']['email'];
    $currency = $order['currency_code'];
    
    $pesapal = createPesapalOrder($orderId, $amount, $email,$currency);
    
    if (!empty($pesapal['redirect_url'])) {
      echo json_encode(['success' => true, 'redirect_url' => $pesapal['redirect_url']]);
    } else {
      echo json_encode(['success' => false, 'error' => $pesapal['error'] ?? 'Unknown error']);
    }

} catch (\Exception $e) {
    echo json_encode(['success' => false, 'error' => $e]);
    exit;
}
