<?php

require_once __DIR__ . '/../lib/pesapal_client.php';
require_once __DIR__ . '/../lib/bigcommerce_client.php';

// Pesapal sends JSON POST
$data = json_decode(file_get_contents('php://input'), true);
file_put_contents(__DIR__.'/ipndata.json',json_encode($data,JSON_PRETTY_PRINT));
$trackingId = $data['OrderTrackingId'] ?? null;

if (!$trackingId) {
    http_response_code(400);
    echo "Missing tracking ID";
    exit;
}

// Verify payment with Pesapal
$status = verifyPesapalPayment($trackingId);

if (!$status) {
    http_response_code(500);
    echo "Verification failed";
    exit;
}

$merchantRef = $status['order_id'] ?? null;
if (!$merchantRef) {
    error_log("Missing merchant_reference in Pesapal IPN");
    http_response_code(400);
    exit;
}

// Extract BigCommerce order ID
$parts = explode('-', $merchantRef);
$bcOrderId = end($parts);

// Only update if payment completed
if ($status['status'] === 'Completed') {
    markOrderAsPaid(
        $bcOrderId,
        'Pesapal',
        $status['amount'],
        $status['confirmation_code']
    );
}

// Return 200 OK to Pesapal
http_response_code(200);
echo "OK";
