<?php
function http_post($url, $data, $headers = []) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => array_merge(['Content-Type: application/json'], $headers)
  ]);
  $result = curl_exec($ch);
  $err = curl_error($ch);
  curl_close($ch);

  if ($err) return ['success' => false, 'error' => $err];

  $decoded = json_decode($result, true);
  return ['success' => true, 'data' => $decoded];
}

function http_get($url, $headers = []) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers
  ]);
  $result = curl_exec($ch);
  $err = curl_error($ch);
  curl_close($ch);

  if ($err) return ['success' => false, 'error' => $err];

  $decoded = json_decode($result, true);
  return ['success' => true, 'data' => $decoded];
}
